<?php
	include 'includes/session.php';
	$conn = $pdo->open();

	$output = array('list'=>'','count'=>0);

	if(isset($_SESSION['user'])){
		try{
			$stmt = $conn->prepare("SELECT *, products.name AS prodname, category.name AS catname FROM cart LEFT JOIN products ON products.id=cart.product_id LEFT JOIN category ON category.id=products.category_id WHERE user_id=:user_id");
			$stmt->execute(['user_id'=>$user['id']]);
			foreach($stmt as $row){
				$output['count']++;
				$image = (!empty($row['photo'])) ? 'images/'.$row['photo'] : 'images/noimage.jpg';
				$productname = (strlen($row['prodname']) > 30) ? substr_replace($row['prodname'], '...', 27) : $row['prodname'];
				$output['list'] .= "
					<li>
						<a href='product.php?product=".$row['slug']."'>
							<div class='pull-left'>
								<img src='".$image."' class='thumbnail' alt='User Image'>
							</div>
							<h4>
		                        <b>".$row['catname']."</b>
		                        <small>&times; ".$row['quantity']."</small>
		                    </h4>
		                    <p>".$productname."</p>
						</a>
					</li>
				";
			}
		}
		catch(PDOException $e){
			$output['message'] = $e->getMessage();
		}
	}
	else{
		if(!isset($_SESSION['cart'])){
			$_SESSION['cart'] = array();
		}

		if(empty($_SESSION['cart'])){
			$output['count'] = 0;
		}
		else{
			$price=0;
			foreach($_SESSION['cart'] as $row){
				$price=$price + $product['discount_price'];
				$output['count']++;
				$stmt = $conn->prepare("SELECT *, products.name AS prodname, category.name AS catname FROM products LEFT JOIN category ON category.id=products.category_id WHERE products.id=:id");
				$stmt->execute(['id'=>$row['productid']]);
				$product = $stmt->fetch();
				$image = (!empty($product['photo'])) ? 'ecommerce/images/'.$product['photo'] : 'ecommerce/images/noimage.jpg';
				$output['list'] .= "
				<li class='product-item' id='cart_menu'>
					<table class='table cart-table'>
					<tbody>
										   <tr>
											   <td class='product-item-image'>
												   <a href='detail.html' class='' title=''>
													   <img src='".$image."'alt='' class='img-responsive'>
												   </a>
												   <button class='remove-product-cart smooth'>
													   <i class='fa fa-times'></i>
												   </button>
											   </td>
											   <td class='product-item-name'>
												   <h4 class='product-name'>
													   <a href='detail.html' class='smooth' title=''>".$product['prodname']."</a>
												   </h4>
												   <span class='product-item-quantity'>".$row['quantity']."</span>
											   </td>
											   <td class='product-item-price'>
												   <span class='shopping-price'>AED ".$product['discount_price']."</span>
											   </td>
										   </tr>
										
									   </tbody>
									   </table>
									   </li>
								
									   <li class='total-price clearfix'>
										   <label class='total-title'>TOTAL:</label>
										   <label class='float-right'>AED ".$price."</label>
									   </li>
									   <li class='shopping-cart-checkout'>
										   <a href='cart.php' class='smooth' title=''>GO TO CART</a>
										   <a href='checkout.html' class='smooth' title=''>CHECKOUT</a>
									   </li>
						
						
				";
				
			}
		}
	}

	$pdo->close();
	echo json_encode($output);

?>
			